<?php

namespace TrustPay\Blocks;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

class TrustPayGateway extends AbstractPaymentMethodType {
    protected $name = 'trustpay_gateway'; // musí sedieť s JS
    
    private $locale;
    
    private $card_accepted_currencies = [
        'AUD',
        'CAD',
        'CZK',
        'DKK',
        'EUR',
        'GBP',
        'HRK',
        'HUF',
        'JPY',
        'NOK',
        'PLN',
        'RON',
        'SEK',
        'USD',
    ];
    
    private $bt_accepted_currencies = [
        'EUR',
        'CZK'
    ];
    
    private $paypal_currencies = [
        'EUR',	//978	Euro
        'AUD',	//5	Australian Dollar
        'CAD',	//4	Canadian Dollar
        'CHF',	//143	Swiss Franc
        'CZK',	//7	Ceske koruny
        'DKK',	//76	Danish Krone
        'GBP',	//3	British Pound
        'HKD',	//116	Hong Kong Dollar
        'HUF',	//117	Forint
        'ILS',	//124	Shekel
        'JPY',	//128	Yen
        'NOK',	//27	Norwegian Krone
        'PLN',	//191	New Zloty
        'SEK',	//225	Swedish Krona
        'USD'	//1	American Dollar
    ];
    
    private $trustly_currencies = [
        'EUR',//	978	Euro
        'DKK',//	76	Danish Krone
        'NOK',//	27	Norwegian Krone
        'SEK'   //	225	Swedish Krona
    ];
    
    private $paysafecard_currencies = [
        //'AUD',//	036	Australian Dollar
        //'BGN',//	975	Bulgarian lev
        //'CAD',//	124	Canadian Dollar
        //'CHF',//	756	Swiss Franc
        //'CZK',//	203	Czech koruna
        //'DKK',//	208	Danish Krone
        'EUR',//	978	Euro
        'GBP',//	826	Pound sterling
        //'HRK',//	191	Croatian kuna
        //'HUF',//	348	Hungarian forint
        'PLN',//	985	Polish zloty
        //'RON',//	946	Romanian leu
        //'SEK',//	752	Swedish Krona
        'USD',//	840	United States doll
    ];
    
    public function initialize() {
        $this->settings = get_option('woocommerce_trustpay_gateway_settings', []);
        
        $this->locale = isset($this->settings['locale'])? $this->settings['locale'] : 'en';
    }

    public function get_payment_method_script_handles() {
        
        $script_handle = 'wc-trustpay-gateway-blocks';

        // register script
        wp_register_script(
            $script_handle,
            plugins_url('../assets/js/trustpay-block.js', __FILE__),
            [
                'wp-element', 
                'wc-blocks-registry', 
                'wc-settings',
                'wp-html-entities',
                'wp-i18n', 
            ],
            TRUSTPAY_VERSION,
            true
        );

        // localize data
        wp_add_inline_script(
            $script_handle,
            'window.wc = window.wc || {}; window.wc.wcSettings = window.wc.wcSettings || {}; window.wc.wcSettings["trustpay_gateway_data"] = ' . json_encode($this->get_localized_data()) . ';',
            'before'
        );

        // optional CSS
        
        wp_register_style(
            'trustpay_block_style',
            plugins_url('../assets/css/trustpay_block.css', __FILE__),
            [],
            TRUSTPAY_VERSION,
            'all'
        );
        
        wp_enqueue_style('trustpay_block_style');
        
        return [ $script_handle ];
    }

    public function get_payment_method_data() {
        return [
            'title' => isset($this->settings['title']) && $this->settings['title'] ? $this->settings['title'] : 'finby',
            'description' => isset($this->settings['description']) && $this->settings['description'] ? $this->settings['description'] : '',
        ];
    }
    
    private function getLocale() {
        return $this->locale;
    }
    
    private function get_localized_data() {
        $paymentMethods = [];

        $currency = get_woocommerce_currency();
        
        global $woocommerce;

        if (isset($this->settings['enable_wire']) && $this->settings['enable_wire'] == 'yes' && $this->isBtAcceptedCurrency(get_woocommerce_currency())) {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_wire',
                'name' => getTrustPayTranslation('bank_tranfer', $this->getLocale()),
                'logo' => plugins_url('../assets/images/online-banking.png', __FILE__),
                'value' => 'wire',
            ];
        }

        if (isset($this->settings['enable_card']) && $this->settings['enable_card'] == 'yes' && $this->isCardAcceptedCurrency(get_woocommerce_currency())) {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_card',
                'name' => getTrustPayTranslation('credit_card', $this->getLocale()),
                'logo' => plugins_url('../assets/images/visa-master_card-maestro.png', __FILE__),
                'value' => 'card',
            ];
        }
        
        if (isset($this->settings['enable_eps']) && $this->settings['enable_eps'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_eps',
                'name' => getTrustPayTranslation('eps', $this->getLocale()),
                'logo' => plugins_url('../assets/images/eps.png', __FILE__),
                'value' => 'eps',
            ];
        }
        
        if (isset($this->settings['enable_giropay']) && $this->settings['enable_giropay'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_giropay',
                'name' => getTrustPayTranslation('giropay', $this->getLocale()),
                'logo' => plugins_url('../assets/images/giropay.png', __FILE__),
                'value' => 'giropay',
            ];
        }
        
        if (isset($this->settings['enable_ideal']) && $this->settings['enable_ideal'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_ideal',
                'name' => getTrustPayTranslation('ideal', $this->getLocale()),
                'logo' => plugins_url('../assets/images/ideal.png', __FILE__),
                'value' => 'ideal',
            ];
        }
        
        if (isset($this->settings['enable_blik']) && $this->settings['enable_blik'] == 'yes' && get_woocommerce_currency() == 'PLN') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_blik',
                'name' => getTrustPayTranslation('blik', $this->getLocale()),
                'logo' => plugins_url('../assets/images/blik.jfif', __FILE__),
                'value' => 'blik',
            ];
        }
        
        if (isset($this->settings['enable_openbanking']) && $this->settings['enable_openbanking'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_openbanking',
                'name' => getTrustPayTranslation('openbanking', $this->getLocale()),
                'logo' => plugins_url('../assets/images/ExpressUberweisung_bottom1.svg', __FILE__),
                'value' => 'openbanking',
            ];
        }
        
        if (isset($this->settings['enable_tpay']) && $this->settings['enable_tpay'] == 'yes' && get_woocommerce_currency() == 'PLN') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_tpay',
                'name' => getTrustPayTranslation('tpay', $this->getLocale()),
                'logo' => plugins_url('../assets/images/tpay.png', __FILE__),
                'value' => 'tpay',
            ];
        }
        
        if (isset($this->settings['enable_wechatpay']) && $this->settings['enable_wechatpay'] == 'yes' && (get_woocommerce_currency() == 'EUR' || get_woocommerce_currency() == 'CNY')) {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_wechatpay',
                'name' => getTrustPayTranslation('wechatpay', $this->getLocale()),
                'logo' => plugins_url('../assets/images/wechatpay.png', __FILE__),
                'value' => 'wechatpay',
            ];
        }
        
        if (isset($this->settings['enable_mybank']) && $this->settings['enable_mybank'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_mybank',
                'name' => getTrustPayTranslation('mybank', $this->getLocale()),
                'logo' => plugins_url('../assets/images/mybank.png', __FILE__),
                'value' => 'mybank',
            ];
        }
        
        if (isset($this->settings['enable_bancontact']) && $this->settings['enable_bancontact'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_bancontact',
                'name' => getTrustPayTranslation('bancontact', $this->getLocale()),
                'logo' => plugins_url('../assets/images/bancontact.png', __FILE__),
                'value' => 'bancontact',
            ];
        }
        
        if (isset($this->settings['enable_satispay']) && $this->settings['enable_satispay'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_satispay',
                'name' => getTrustPayTranslation('satispay', $this->getLocale()),
                'logo' => plugins_url('../assets/images/satispay.jfif', __FILE__),
                'value' => 'satispay',
            ];
        }
        
        if (isset($this->settings['enable_sofort']) && $this->settings['enable_sofort'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_sofort',
                'name' => getTrustPayTranslation('sofort', $this->getLocale()),
                'logo' => plugins_url('../assets/images/sofort.svg', __FILE__),
                'value' => 'sofort',
            ];
        }
        
        if (isset($this->settings['enable_aircashpay']) && $this->settings['enable_aircashpay'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_aircashpay',
                'name' => getTrustPayTranslation('aircashpay', $this->getLocale()),
                'logo' => plugins_url('../assets/images/aircashpay.png', __FILE__),
                'value' => 'aircashpay',
            ];
        }
        
        if (isset($this->settings['enable_paypal']) && $this->settings['enable_paypal'] == 'yes' && in_array(get_woocommerce_currency(), $this->paypal_currencies)) {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_paypal',
                'name' => getTrustPayTranslation('paypal', $this->getLocale()),
                'logo' => plugins_url('../assets/images/paypal.png', __FILE__),
                'value' => 'paypal',
            ];
        }
        
        if (isset($this->settings['enable_paytrail']) && $this->settings['enable_paytrail'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_paytrail',
                'name' => getTrustPayTranslation('paytrail', $this->getLocale()),
                'logo' => plugins_url('../assets/images/paytrail.webp', __FILE__),
                'value' => 'paytrail',
            ];
        }
        
        
        if (isset($this->settings['enable_trustly']) && $this->settings['enable_trustly'] == 'yes' && in_array(get_woocommerce_currency(), $this->trustly_currencies)) {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_trustly',
                'name' => getTrustPayTranslation('trustly', $this->getLocale()),
                'logo' => plugins_url('../assets/images/trustly.png', __FILE__),
                'value' => 'trustly',
            ];
        }
        
        if (isset($this->settings['enable_paysafecard']) && $this->settings['enable_paysafecard'] == 'yes' && in_array(get_woocommerce_currency(), $this->paysafecard_currencies)) {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_paysafecard',
                'name' => getTrustPayTranslation('paysafecard', $this->getLocale()),
                'logo' => plugins_url('../assets/images/paysafecard.jpg', __FILE__),
                'value' => 'paysafecard',
            ];
        }
        
        if (isset($this->settings['enable_cashtocode']) && $this->settings['enable_cashtocode'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_cashtocode',
                'name' => getTrustPayTranslation('cashtocode', $this->getLocale()),
                'logo' => plugins_url('../assets/images/cashtocode.webp', __FILE__),
                'value' => 'cashtocode',
            ];
        }
        
        if (isset($this->settings['enable_payconiq']) && $this->settings['enable_payconiq'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_payconiq',
                'name' => getTrustPayTranslation('payconiq', $this->getLocale()),
                'logo' => plugins_url('../assets/images/payconiq.png', __FILE__),
                'value' => 'payconiq',
            ];
        }
        
        if (isset($this->settings['enable_multibanco']) && $this->settings['enable_multibanco'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_multibanco',
                'name' => getTrustPayTranslation('multibanco', $this->getLocale()),
                'logo' => plugins_url('../assets/images/multibanco.png', __FILE__),
                'value' => 'multibanco',
            ];
        }
        
        if (isset($this->settings['enable_nasplatkytb']) && $this->settings['enable_nasplatkytb'] == 'yes' && get_woocommerce_currency() == 'EUR' && isset($woocommerce->cart->total) && $woocommerce->cart->total >= 100) {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_nasplatkytb',
                'name' => getTrustPayTranslation('nasplatkytb', $this->getLocale()),
                'logo' => plugins_url('../assets/images/nasplatkytb.jpg', __FILE__),
                'value' => 'nasplatkytb',
            ];
        }
        
        
        if (isset($this->settings['enable_skippay']) && $this->settings['enable_skippay'] == 'yes' && get_woocommerce_currency() == 'CZK') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_skippay',
                'name' => getTrustPayTranslation('skippay', $this->getLocale()),
                'logo' => plugins_url('../assets/images/skippay.png', __FILE__),
                'value' => 'skippay',
            ];
        }
        
        if (isset($this->settings['enable_sepact']) && $this->settings['enable_sepact'] == 'yes' && get_woocommerce_currency() == 'EUR') {
            $paymentMethods[] = [
                'id' => 'payment_method_trustpay_gateway_sepact',
                'name' => getTrustPayTranslation('sepact', $this->getLocale()),
                'logo' => plugins_url('../assets/images/sepact.png', __FILE__),
                'value' => 'sepact',
            ];
        }
        
        return [
            'title' => $this->settings['title'] ?? 'finby',
            'description' => $this->settings['description'] ?? '',
            'tpLogoUrl' => plugins_url('../assets/images/logo.png', __FILE__),
            'showLogos' => isset($this->settings['show_logo']) && $this->settings['show_logo'] == 'yes' ? true : false,// ?? true,
            'iframe' => isset($this->settings['iframe']) && $this->settings['iframe'] == 'yes' ? true : false,
            'paymentMethods' => $paymentMethods,
            'checkoutUrl' => wc_get_checkout_url(),
            'i18n' => [
                'errorDefault' => 'Chyba pri platbe',
            ]
        ];
        
    }
    
    public function isCardAcceptedCurrency($currency)
    {
        return in_array($currency, $this->card_accepted_currencies);
    }
    
    public function isBtAcceptedCurrency($currency)
    {
        return in_array($currency, $this->bt_accepted_currencies);
    }
}
