<?php
namespace Trustpay;

class ResponseGiropay extends Response {
    public function getTransactionId() {
        return $this->paymentRequestId;
    }

    public function validateSignature() {
        // musi ist aby sa naplnilo $this->signature
        $this->getSigData();
        
        return $this->signature == $this->SignatureData->getSignature($this->getSigData());
    }

    protected function getSigData() {
        
        /*
            {
                "PaymentMethod": "Giropay",
                "MerchantIdentification": {
                  "ProjectId": "4101111111"
                },
                "PaymentInformation": {
                  "Amount": {
                    "Amount": "25.00",
                    "Currency": "EUR"
                  },
                  "CreditDebitIndicator": "CRDT",
                  "Status": "Paid",
                  "References": {
                    "MerchantReference": "1234567890",
                    "PaymentId": "49863043",
                    "PaymentRequestId": "1234"
                  },
                  "Debtor": {
                    "Name": "Test name"
                  },
                  "DebtorAccount": {
                    "Iban": "AT483200000012345864"
                  },
                  "DebtorAgent": {
                    "Bic": "TESTATTT421"
                  }
                },
                "Signature": "013B192245EF81995E3F219E064F42DC1E1F4A6BC67CB546E1CCA6DC35E5CB73"
              }
         *          */
        $jsonData = json_decode(file_get_contents('php://input'), true);
        
        $data = array();

        if(is_array($jsonData)) {
            foreach($jsonData as $key1 => $value) {
                if(is_array($value)) {
                    foreach($value as $key2 => $value2) {
                        if(is_array($value2)) {
                            foreach($value2 as $key3 => $value3) {
                                
                                
                                if($key3 == 'PaymentRequestId') {
                                    $this->paymentRequestId = $value3;
                                    
                                } elseif($key3 == 'Amount') {
                                    $value3 = (string) number_format($value3, 2, '.', '');
                                    $this->amount = $value3;
                                    
                                } elseif($key3 == 'Currency') {
                                    $this->currency = $value3;
                                    
                                } elseif($key3 == 'MerchantReference') {
                                    $this->orderId = $this->reference = $value3;
                                     
                                } elseif($key3 == 'PaymentId') {
                                    $this->paymentId = $value3;
                                     
                                }
                                
                                $data[] = $value3;
                                
                                
                            }
                        } else {
                            $data[] = $value2;
                            
                            if($key2 == 'ProjectId') {
                                $this->accountId = $value2;
                            } elseif($key2 == 'Status' && $value2 == 'Paid') {
                                $this->resultCode = ResultCodes::SUCCESS;
                            }
                            elseif($key2 == 'Status' && $value2 == 'Authorized') {
                                $this->resultCode = ResultCodes::AUTHORIZED;
                            }
                            elseif($key2 == 'Status' && $value2 == 'Rejected') {
                                $this->resultCode = ResultCodes::REJECTED;
                            }
                        }
                    }
                } else {
                    
                    if($key1 == 'Signature') {
                        $this->signature = $value;
                    } else {
                        $data[] = $value;
                    }
                }
            }
        }
        
        $data = array_filter($data);
        sort($data, SORT_STRING);
        
        return $data;
    }
}