<?php
use Trustpay\Order;
use Trustpay\Payment;
use Trustpay\PaymentWire;
use Trustpay\PaymentCard;
use Trustpay\PaymentEPS;
use Trustpay\PaymentGiropay;
use Trustpay\PaymentIdeal;
use Trustpay\PaymentBlik;
use Trustpay\PaymentOpenBanking;
use Trustpay\PaymentTpay;
use Trustpay\PaymentWechatpay;
use Trustpay\PaymentMyBank;
use Trustpay\PaymentBancontact;
use Trustpay\PaymentSatispay;
use Trustpay\PaymentSofort;
use Trustpay\PaymentAircashPay;
use Trustpay\PaymentPaypal;
use Trustpay\PaymentPaytrail;
use Trustpay\PaymentTrustly;
use Trustpay\PaymentPaysafecard;
use Trustpay\PaymentCashToCode;
use Trustpay\PaymentPayconiq;
use Trustpay\PaymentMultibanco;
use Trustpay\PaymentNasplatkyTB;
use Trustpay\PaymentSkipPay;
use Trustpay\PaymentSepaCT;
use Trustpay\PaymentType;
use Trustpay\ResultCodes;

class WC_Trustpay_Gateway extends WC_Payment_Gateway {
    
    private $live_account_id;
    private $live_secret_key;
    private $test_account_id;
    private $test_secret_key;
    private $sandbox;
    private $methods;
    private $currency;
    private $locale;
    private $show_logo;
    private $iframe;
    
    private $enable_wire;
    private $enable_card;
    private $enable_eps;
    private $enable_giropay;
    private $enable_ideal;
    private $enable_blik;
    private $enable_openbanking;
    private $enable_tpay;
    private $enable_wechatpay;
    private $enable_mybank;
    private $enable_bancontact;
    private $enable_satispay;
    private $enable_sofort;
    private $enable_aircashpay;
    private $enable_paypal;
    private $enable_paytrail;
    private $enable_trustly;
    private $enable_paysafecard;
    private $enable_cashtocode;
    private $enable_payconiq;
    private $enable_multibanco;
    private $enable_nasplatkytb;
    private $enable_skippay;
    private $enable_sepact;
    
    private $order_status_rejected;
    
    
    
    private $card_accepted_currencies = [
        'AUD',
        'CAD',
        'CZK',
        'DKK',
        'EUR',
        'GBP',
        'HRK',
        'HUF',
        'JPY',
        'NOK',
        'PLN',
        'RON',
        'SEK',
        'USD',
        'RSD',
        'UAH',
        'NZD',
        'ZAR',
        'BGN',
        'RUB',
        'ARS',
        'CHF',
        'CNY',
        'INR',
        'NGN',
        'GHS',
        'KES',
    ];
    
    private $paypal_currencies = [
        'EUR',	//978	Euro
        'AUD',	//5	Australian Dollar
        'CAD',	//4	Canadian Dollar
        'CHF',	//143	Swiss Franc
        'CZK',	//7	Ceske koruny
        'DKK',	//76	Danish Krone
        'GBP',	//3	British Pound
        'HKD',	//116	Hong Kong Dollar
        'HUF',	//117	Forint
        'ILS',	//124	Shekel
        'JPY',	//128	Yen
        'NOK',	//27	Norwegian Krone
        'PLN',	//191	New Zloty
        'SEK',	//225	Swedish Krona
        'USD'	//1	American Dollar
    ];
    
    private $trustly_currencies = [
        'EUR',//	978	Euro
        'DKK',//	76	Danish Krone
        'NOK',//	27	Norwegian Krone
        'SEK'   //	225	Swedish Krona
    ];
    
    private $paysafecard_currencies = [
        //'AUD',//	036	Australian Dollar
        //'BGN',//	975	Bulgarian lev
        //'CAD',//	124	Canadian Dollar
        //'CHF',//	756	Swiss Franc
        //'CZK',//	203	Czech koruna
        //'DKK',//	208	Danish Krone
        'EUR',//	978	Euro
        'GBP',//	826	Pound sterling
        //'HRK',//	191	Croatian kuna
        //'HUF',//	348	Hungarian forint
        'PLN',//	985	Polish zloty
        //'RON',//	946	Romanian leu
        //'SEK',//	752	Swedish Krona
        'USD',//	840	United States doll
    ];
    
    public function process_admin_options() {
        // Najprv uloží všetko ako normálne
        parent::process_admin_options();

        // Teraz získaš hodnotu
        $title = $this->get_option( 'title' );

        // Prepíšeš ju, ak treba
        if(mb_strtolower($this->title) == 'trustpay' || mb_strtolower($this->title) == 'trust pay') {
            $this->settings['title'] = 'finby';
            $option_key = 'woocommerce_' . $this->id . '_settings';
            update_option( $option_key, $this->settings );
        }
    }

    public function __construct() {
        loadTrustPayLibrary();

        $this->id                   = 'trustpay_gateway';
        $this->icon                 = apply_filters( 'woocommerce_trustpay_icon', '' );
        $this->has_fields           = true;
        $this->method_title         = _x( 'finby', 'woocommerce' );
        $this->method_description   = __( 'Instant bank transfer, card payments and various payment methods.', 'woocommerce' );

        $this->init_form_fields();
        $this->init_settings();

        $this->title                = $this->get_option( 'title' );
        
        $this->sandbox              = $this->get_option( 'sandbox' );
        
        $this->live_account_id      = $this->get_option( 'live_account_id' );
        $this->live_secret_key      = $this->get_option( 'live_secret_key' );
        $this->test_account_id      = $this->get_option( 'test_account_id' );
        $this->test_secret_key      = $this->get_option( 'test_secret_key' );
        
        $this->enable_wire              = $this->get_option( 'enable_wire' ) == 'yes'? true : false;
        $this->enable_card              = $this->get_option( 'enable_card' ) == 'yes'? true : false;
        $this->enable_eps               = $this->get_option( 'enable_eps' ) == 'yes'? true : false;
        $this->enable_giropay           = $this->get_option( 'enable_giropay' ) == 'yes'? true : false;
        $this->enable_ideal             = $this->get_option( 'enable_ideal' ) == 'yes'? true : false;
        $this->enable_blik              = $this->get_option( 'enable_blik' ) == 'yes'? true : false;
        $this->enable_openbanking       = $this->get_option( 'enable_openbanking' ) == 'yes'? true : false;
        $this->enable_tpay              = $this->get_option( 'enable_tpay' ) == 'yes'? true : false;
        $this->enable_wechatpay         = $this->get_option( 'enable_wechatpay' ) == 'yes'? true : false;
        $this->enable_mybank            = $this->get_option( 'enable_mybank' ) == 'yes'? true : false;
        $this->enable_bancontact        = $this->get_option( 'enable_bancontact' ) == 'yes'? true : false;
        $this->enable_satispay          = $this->get_option( 'enable_satispay' ) == 'yes'? true : false;
        $this->enable_sofort            = $this->get_option( 'enable_sofort' ) == 'yes'? true : false;
        $this->enable_aircashpay        = $this->get_option( 'enable_aircashpay' ) == 'yes'? true : false;
        $this->enable_paypal            = $this->get_option( 'enable_paypal' ) == 'yes'? true : false;
        $this->enable_paytrail          = $this->get_option( 'enable_paytrail' ) == 'yes'? true : false;
        $this->enable_trustly           = $this->get_option( 'enable_trustly' ) == 'yes'? true : false;
        $this->enable_paysafecard       = $this->get_option( 'enable_paysafecard' ) == 'yes'? true : false;
        $this->enable_cashtocode        = $this->get_option( 'enable_cashtocode' ) == 'yes'? true : false;
        $this->enable_payconiq          = $this->get_option( 'enable_payconiq' ) == 'yes'? true : false;
        $this->enable_multibanco        = $this->get_option( 'enable_multibanco' ) == 'yes'? true : false;
        $this->enable_nasplatkytb       = $this->get_option( 'enable_nasplatkytb' ) == 'yes'? true : false;
        $this->enable_skippay           = $this->get_option( 'enable_skippay' ) == 'yes'? true : false;
        $this->enable_sepact            = $this->get_option( 'enable_sepact' ) == 'yes'? true : false;
        
        $this->currency             = $this->get_option( 'currency' );
        $this->locale               = $this->get_option( 'locale' );
        $this->show_logo            = $this->get_option( 'show_logo' );
        $this->iframe               = $this->get_option( 'iframe' );
        
        $this->order_status_rejected  = $this->get_option( 'order_status_rejected' ) ? $this->get_option( 'order_status_rejected' ) : 'failed';
        
        add_action( 'woocommerce_update_options_payment_gateways_' . $this->id,      array( $this, 'process_admin_options' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_WIRE, array( $this, 'callback_wire' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_CARD, array( $this, 'callback_card' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_EPS,  array( $this, 'callback_eps' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_GIROPAY, array( $this, 'callback_giropay' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_IDEAL, array( $this, 'callback_ideal' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_BLIK, array( $this, 'callback_blik' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_OPENBANKING, array( $this, 'callback_openbanking' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_TPAY, array( $this, 'callback_tpay' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_WECHATPAY, array( $this, 'callback_wechatpay' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_MYBANK, array( $this, 'callback_mybank' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_BANCONTACT, array( $this, 'callback_bancontact' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_SATISPAY, array( $this, 'callback_satispay' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_SOFORT, array( $this, 'callback_sofort' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_AIRCASHPAY, array( $this, 'callback_aircashpay' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_PAYPAL, array( $this, 'callback_paypal' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_PAYTRAIL, array( $this, 'callback_paytrail' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_TRUSTLY, array( $this, 'callback_trustly' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_PAYSAFECARD, array( $this, 'callback_paysafecard' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_CASHTOCODE, array( $this, 'callback_cashtocode' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_PAYCONIQ, array( $this, 'callback_payconiq' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_MULTIBANCO, array( $this, 'callback_multibanco' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_NASPLATKYTB, array( $this, 'callback_nasplatkytb' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_SKIPPAY, array( $this, 'callback_skippay' ) );
        add_action( 'woocommerce_api_wc_gateway_trustpay_' . Payment::ENDPOINT_SEPACT, array( $this, 'callback_sepact' ) );
        add_action( 'woocommerce_before_checkout_form',                              array( $this, 'checkout_response_error' ) );
        add_action( 'before_woocommerce_pay',                                        array( $this, 'checkout_response_error' ) );
    }
    
    public function isCardAcceptedCurrency($currency)
    {
        return in_array($currency, $this->card_accepted_currencies);
    }

    public function init_form_fields() {
        $this->form_fields = array(
            'enabled' => array(
                'title' => __( 'Enable/Disable', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ). ' finby payment',
                'default' => 'yes'
            ),
            'title' => array(
                'title' => __( 'Title', 'woocommerce' ),
                'type' => 'text',
                'description' => __( 'This controls the title which the user sees during checkout.', 'woocommerce' ),
                'default' => __( 'finby', 'woocommerce' ),
                'desc_tip'      => true,
            ),
            'sandbox' => array(
                'title' => __( 'Sandbox', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Sandbox',
                'default' => 'no'
            ),
            
            'live_account_id' => array(
                'title' => __( 'Live Account ID/Project ID', 'woocommerce' ),
                'type' => 'text',
                'default' => '',
            ),
            'live_secret_key' => array(
                'title' => __( 'Live Secret key', 'woocommerce' ),
                'type' => 'text',
                'default' => '',
            ),
            'test_account_id' => array(
                'title' => __( 'Test Account ID/Project ID', 'woocommerce' ),
                'type' => 'text',
                'default' => '',
            ),
            'test_secret_key' => array(
                'title' => __( 'Test Secret key', 'woocommerce' ),
                'type' => 'text',
                'default' => '',
            ),
            
            'enable_wire' => array(
                'title' => __( 'Bank Tranfer', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Bank Tranfer',
                'default' => 'yes'
            ),
            
            'enable_card' => array(
                'title' => __( 'Credit Card', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Credit Card',
                'default' => 'yes'
            ),
            
            'enable_eps' => array(
                'title' => __( 'EPS', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' EPS',
                'default' => 'no'
            ),
            /*
            'enable_giropay' => array(
                'title' => __( 'GiroPay', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' GiroPay',
                'default' => 'no'
            ),
            */
            'enable_ideal' => array(
                'title' => __( 'IDeal', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' IDeal',
                'default' => 'no'
            ),
            
            'enable_blik' => array(
                'title' => __( 'Blik', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Blik',
                'default' => 'no'
            ),
            
            'enable_openbanking' => array(
                'title' => __( 'OpenBanking', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' OpenBanking',
                'default' => 'no'
            ),
            
            'enable_tpay' => array(
                'title' => __( 'Instant Bank Transfers (PL)', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Instant Bank Transfers (PL)',
                'default' => 'no'
            ),
            
            'enable_wechatpay' => array(
                'title' => __( 'WeChatPay', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' WeChatPay',
                'default' => 'no'
            ),
            
            'enable_mybank' => array(
                'title' => __( 'MyBank', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' MyBank',
                'default' => 'no'
            ),
            
            'enable_bancontact' => array(
                'title' => __( 'Bancontact', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Bancontact',
                'default' => 'no'
            ),
            
            'enable_satispay' => array(
                'title' => __( 'Satispay', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Satispay',
                'default' => 'no'
            ),
            
            'enable_sofort' => array(
                'title' => __( 'Sofort', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Sofort',
                'default' => 'no'
            ),
            
            'enable_aircashpay' => array(
                'title' => __( 'Aircashpay', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Aircashpay',
                'default' => 'no'
            ),
            
            'enable_paypal' => array(
                'title' => __( 'PayPal', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' PayPal',
                'default' => 'no'
            ),
            
            'enable_paytrail' => array(
                'title' => __( 'Paytrail', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Paytrail',
                'default' => 'no'
            ),
            
            'enable_trustly' => array(
                'title' => __( 'Trustly', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Trustly',
                'default' => 'no'
            ),
            
            'enable_paysafecard' => array(
                'title' => __( 'Paysafecard', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Paysafecard',
                'default' => 'no'
            ),
            
            'enable_cashtocode' => array(
                'title' => __( 'CashToCode', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' CashToCode',
                'default' => 'no'
            ),
            
            'enable_payconiq' => array(
                'title' => __( 'Payconiq', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Payconiq',
                'default' => 'no'
            ),
            
            'enable_multibanco' => array(
                'title' => __( 'Multibanco', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Multibanco',
                'default' => 'no'
            ),
            
            'enable_nasplatkytb' => array(
                'title' => __( 'NasplatkyTB', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' NasplatkyTB',
                'default' => 'no'
            ),
            
            'enable_skippay' => array(
                'title' => __( 'SkipPay', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' SkipPay',
                'default' => 'no'
            ),
            
            'enable_sepact' => array(
                'title' => __( 'Sepa Credit Transfer', 'woocommerce' ),
                'type' => 'checkbox',
                'label' => __( 'Enable', 'woocommerce' ) . ' Sepa Credit Transfer',
                'default' => 'no'
            ),
            
            'currency' => array(
                //'title' => __( 'Accepted Currency', 'woocommerce' ),
                'title' => getTrustPayTranslation('Accepted Currency', mb_substr(get_locale(), 0, 2)),
                'type' => 'select',
                'default' => 'EUR',
                'options' => array(
                    'EUR' => __( 'EUR', 'woocommerce' ),
                    'CZK' => __( 'CZK', 'woocommerce' ),
                ),
            ),
            'locale' => array(
                //'title' => __( 'Localisation', 'woocommerce' ),
                'title' => getTrustPayTranslation('Localisation', mb_substr(get_locale(), 0, 2)),
                'type' => 'select',
                'default' => 'en',
                'options' => array(
                    'en' => __( 'English', 'woocommerce' ),
                    'sk' => __( 'Slovensky', 'woocommerce' ),
                    'cs' => __( 'Česky', 'woocommerce' ),
                ),
            ),
            'show_logo' => array(
                //'title' => __( 'Show Logos', 'woocommerce' ),
                'title' => getTrustPayTranslation('Show Logos', mb_substr(get_locale(), 0, 2)),
                'type' => 'checkbox',
                //'label' => __( 'Show Logos in checkout confirmation options', 'woocommerce' ),
                'label' => getTrustPayTranslation('Show Logos in checkout confirmation options', mb_substr(get_locale(), 0, 2)),
                'default' => 'yes'
            ),
            'iframe' => array(
                'title' =>  __( 'Iframe', 'woocommerce' ) ,
                'type' => 'checkbox',
                //'label' => __( 'Please, read the <a href="https://doc.finby.eu" target="_blank">documentation</a> before switching iframe option on, or changing the standard woocommerce checkout', 'woocommerce' ),
                'label' => getTrustPayTranslation('Please, read the <a href="https://doc.finby.eu" target="_blank">documentation</a> before switching iframe option on, or changing the standard woocommerce checkout', mb_substr(get_locale(), 0, 2)),
                'default' => 'yes'
             ),
            
            'order_status_rejected' => array(
                'title' => getTrustPayTranslation('Set_Order_Status_Rejected', mb_substr(get_locale(), 0, 2)),
                'type' => 'select',
                'default' => 'failed',
                'options' => array(
                    'failed' => getTrustPayTranslation('Order Failed', mb_substr(get_locale(), 0, 2)),
                    'cancelled' => getTrustPayTranslation('Order Cancelled', mb_substr(get_locale(), 0, 2)),
                ),
            ),
        );
    }

    public function checkout_response_error() {
        $error = false;

        if(isset($_GET['AcquirerResponseId']) && getTrustPayTranslation($_GET['AcquirerResponseId'], $this->getLocale())) {
            $error = getTrustPayTranslation($_GET['AcquirerResponseId'], $this->getLocale());
        }

        if ($error) { ?>
            <div class="woocommerce-error"><?php echo $error; ?></div>
            <?php
        }
    }
    
    //-------------- 2025 maj ---------------------------------
    public function has_fields() {
        return true;
    }
    
    //----------------------------------------------

    public function payment_fields() {
        
        global $woocommerce;
        
        if(get_woocommerce_currency() == $this->getCurrency() || $this->isCardAcceptedCurrency(get_woocommerce_currency())) {
            ?>
            
            <!-- loader -->
            <script type="text/javascript">
                var trustpayTs;
                
                function onTrustPayPopupLoaded() {
                    hideLoader();
                }
                
                function showLoader() {
                    jQuery('#TrustPayLoader').show();
                    jQuery('button[type="submit"]').prop('disabled', true);
                    trustpayTs = setTimeout(hideLoader, 20000);
                }
                
                function hideLoader() {
                    jQuery('#TrustPayLoader').hide();
                    jQuery('button[type="submit"]').prop('disabled', false);
                    clearTimeout(trustpayTs);
                }
                
                jQuery('#place_order').on('click', function(){
                    showLoader();
                });
                
            </script>
            
            <link rel='stylesheet' id='trustpay-loader-css'  href='<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/css/loader.css'); ?>' media='all' />
            
            <div id="TrustPayLoader">
                <div class="loaderContent">
                    <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/loader.gif'); ?>" style="width:160px; height:120px; max-height: none;" alt=""/>
                </div>
            </div>
            
            <!-- loader end -->
            
            
            <fieldset id="<?php echo esc_attr($this->id); ?>_form" class='wc-payment-form'>
                <?php if($this->enable_wire && get_woocommerce_currency() == $this->getCurrency()): ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_WIRE; ?>"
                                id="payment_method_trustpay_gateway_wire"
                                checked="checked"
                        />
                    <label for="payment_method_trustpay_gateway_wire">
                        <?php echo getTrustPayTranslation('bank_tranfer', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/online-banking.png'); ?>" alt="" style="float:right"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                <?php if($this->enable_card && $this->isCardAcceptedCurrency(get_woocommerce_currency())): ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_CARD; ?>"
                                id="payment_method_trustpay_gateway_card"
                                <?php if($this->enable_card): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_card">
                        <?php echo getTrustPayTranslation('credit_card', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/visa-master_card-maestro.png'); ?>" alt="" style="float:right"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                
                <?php if($this->enable_eps && get_woocommerce_currency() == 'EUR'): //eps berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_EPS; ?>"
                                id="payment_method_trustpay_gateway_eps"
                                <?php if($this->enable_eps): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_eps">
                        <?php echo getTrustPayTranslation('eps', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/eps.png'); ?>" alt="" style="float:right" width="50"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <!--
                <?php if($this->enable_giropay && get_woocommerce_currency() == 'EUR'): //giropay berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_GIROPAY; ?>"
                                id="payment_method_trustpay_gateway_giropay"
                                <?php if($this->enable_giropay): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_giropay">
                        <?php echo getTrustPayTranslation('giropay', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/giropay.png'); ?>" alt="" style="float:right" width="50"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                -->
                
                <?php if($this->enable_ideal && get_woocommerce_currency() == 'EUR'): //ideal berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_IDEAL; ?>"
                                id="payment_method_trustpay_gateway_ideal"
                                <?php if($this->enable_ideal): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_ideal">
                        <?php echo getTrustPayTranslation('ideal', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/ideal.png'); ?>" alt="" style="float:right" width="30"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_blik && get_woocommerce_currency() == 'PLN'): //blik berie len PLN ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_BLIK; ?>"
                                id="payment_method_trustpay_gateway_blik"
                                <?php if($this->enable_blik): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_blik">
                        <?php echo getTrustPayTranslation('blik', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/blik.jfif'); ?>" alt="" style="float:right" width="30"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_openbanking && get_woocommerce_currency() == 'EUR'
                        && in_array($woocommerce->customer->get_billing_country(), ['DE', 'AT'] )): ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_OPENBANKING; ?>"
                                id="payment_method_trustpay_gateway_openbanking "
                                <?php if($this->enable_openbanking ): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_openbanking ">
                        <?php echo getTrustPayTranslation('openbanking', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/ExpressUberweisung_bottom1.svg'); ?>" alt="" style="float:right" width="30"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_tpay && get_woocommerce_currency() == 'PLN'): //tpay berie len PLN ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_TPAY; ?>"
                                id="payment_method_trustpay_gateway_tpay"
                                <?php if($this->enable_tpay): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_tpay">
                        <?php echo getTrustPayTranslation('tpay', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/tpay.png'); ?>" alt="" style="float:right" width="30"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_wechatpay && (get_woocommerce_currency() == 'EUR' || get_woocommerce_currency() == 'CNY')): //wechatpay berie len EUR a CNY ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_WECHATPAY; ?>"
                                id="payment_method_trustpay_gateway_wechatpay"
                                <?php if($this->enable_wechatpay): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_wechatpay">
                        <?php echo getTrustPayTranslation('wechatpay', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/wechatpay.png'); ?>" alt="" style="float:right" width="70"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_mybank && get_woocommerce_currency() == 'EUR' ): // berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_MYBANK; ?>"
                                id="payment_method_trustpay_gateway_mybank"
                                <?php if($this->enable_mybank): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_mybank">
                        <?php echo getTrustPayTranslation('mybank', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/mybank.png'); ?>" alt="" style="float:right" width="50"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_bancontact && get_woocommerce_currency() == 'EUR' ): // berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_BANCONTACT; ?>"
                                id="payment_method_trustpay_gateway_bancontact"
                                <?php if($this->enable_bancontact): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_bancontact">
                        <?php echo getTrustPayTranslation('bancontact', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/bancontact.png'); ?>" alt="" style="float:right" width="40"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_satispay && get_woocommerce_currency() == 'EUR' ): // berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_SATISPAY; ?>"
                                id="payment_method_trustpay_gateway_satispay"
                                <?php if($this->enable_satispay): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_satispay">
                        <?php echo getTrustPayTranslation('satispay', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/satispay.jfif'); ?>" alt="" style="float:right" width="40"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_sofort && get_woocommerce_currency() == 'EUR' && isset($woocommerce->cart->total) && $woocommerce->cart->total >= 0.1 ): // berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_SOFORT; ?>"
                                id="payment_method_trustpay_gateway_sofort"
                                <?php if($this->enable_sofort): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_sofort">
                        <?php echo getTrustPayTranslation('sofort', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/sofort.svg'); ?>" alt="" style="float:right" width="40"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_aircashpay && get_woocommerce_currency() == 'EUR' ): // berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_AIRCASHPAY; ?>"
                                id="payment_method_trustpay_gateway_aircashpay"
                                <?php if($this->enable_aircashpay): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_aircashpay">
                        <?php echo getTrustPayTranslation('aircashpay', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/aircashpay.png'); ?>" alt="" style="float:right" width="90"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_paypal && in_array(get_woocommerce_currency(), $this->paypal_currencies) ): // berie svoje meny ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_PAYPAL; ?>"
                                id="payment_method_trustpay_gateway_paypal"
                                <?php if($this->enable_paypal): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_paypal">
                        <?php echo getTrustPayTranslation('paypal', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/paypal.png'); ?>" alt="" style="float:right" width="70"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_paytrail && get_woocommerce_currency() == 'EUR'  ): // berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_PAYTRAIL; ?>"
                                id="payment_method_trustpay_gateway_paytrail"
                                <?php if($this->enable_paytrail): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_paytrail">
                        <?php echo getTrustPayTranslation('paytrail', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/paytrail.webp'); ?>" alt="" style="float:right" width="40"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_trustly && in_array(get_woocommerce_currency(), $this->trustly_currencies) ): // berie svoje meny ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_TRUSTLY; ?>"
                                id="payment_method_trustpay_gateway_trustly"
                                <?php if($this->enable_trustly): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_trustly">
                        <?php echo getTrustPayTranslation('trustly', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/trustly.png'); ?>" alt="" style="float:right" width="70"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_paysafecard && in_array(get_woocommerce_currency(), $this->paysafecard_currencies) ): // berie svoje meny ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_PAYSAFECARD; ?>"
                                id="payment_method_trustpay_gateway_paysafecard"
                                <?php if($this->enable_paysafecard): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_paysafecard">
                        <?php echo getTrustPayTranslation('paysafecard', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/paysafecard.jpg'); ?>" alt="" style="float:right" width="70"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_cashtocode && get_woocommerce_currency() == 'EUR'  ): // berie len EUR ?>
                <p class="form-row" id="CashToCode" style="display:none;">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_CASHTOCODE; ?>"
                                id="payment_method_trustpay_gateway_cashtocode"
                                <?php if($this->enable_cashtocode): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_cashtocode">
                        <?php echo getTrustPayTranslation('cashtocode', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/cashtocode.webp'); ?>" alt="" style="float:right" width="40"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_payconiq && get_woocommerce_currency() == 'EUR'  ): // berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_PAYCONIQ; ?>"
                                id="payment_method_trustpay_gateway_payconiq"
                                <?php if($this->enable_payconiq): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_payconiq">
                        <?php echo getTrustPayTranslation('payconiq', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/payconiq.png'); ?>" alt="" style="float:right" width="60"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_multibanco && get_woocommerce_currency() == 'EUR'  ): // berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_MULTIBANCO; ?>"
                                id="payment_method_trustpay_gateway_multibanco"
                                <?php if($this->enable_multibanco): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_multibanco">
                        <?php echo getTrustPayTranslation('multibanco', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/multibanco.png'); ?>" alt="" style="float:right" width="28"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_nasplatkytb && get_woocommerce_currency() == 'EUR' && isset($woocommerce->cart->total) && $woocommerce->cart->total >= 100): // berie len EUR a vyssie alebo rovne 100EUR?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_NASPLATKYTB; ?>"
                                id="payment_method_trustpay_gateway_nasplatkytb"
                                <?php if($this->enable_nasplatkytb): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_nasplatkytb">
                        <?php echo getTrustPayTranslation('nasplatkytb', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/nasplatkytb.jpg'); ?>" alt="" style="float:right" width="68"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_skippay && get_woocommerce_currency() == 'CZK'): ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_SKIPPAY; ?>"
                                id="payment_method_trustpay_gateway_skippay"
                                <?php if($this->enable_skippay): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_skippay">
                        <?php echo getTrustPayTranslation('skippay', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/skippay.png'); ?>" alt="" style="float:right" width="28"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                <?php if($this->enable_sepact && get_woocommerce_currency() == 'EUR'): // berie len EUR ?>
                <p class="form-row">
                    
                        <input
                                type="radio"
                                name="trustpay_gateway_method"
                                value="<?php echo Payment::ENDPOINT_SEPACT; ?>"
                                id="payment_method_trustpay_gateway_sepact"
                                <?php if($this->enable_sepact): ?>
                                    checked="checked"
                                <?php endif;?>
                        />
                    <label for="payment_method_trustpay_gateway_sepact">
                        <?php echo getTrustPayTranslation('sepact', $this->getLocale()); ?>
                        <?php if ($this->getShowLogo()) { ?>
                            <img src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/images/sepact.png'); ?>" alt="" style="float:right" width="58"/>
                        <?php } ?>
                    </label>
                </p>
                <?php endif;?>
                
                
                <p></p>
            </fieldset>

            <?php // if ( $this->getIframe() ) { ?>
                <script src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/js/tp-mapi.js?'.TRUSTPAY_VERSION); ?>"></script>
                <script src="<?php echo plugins_url(TRUSTPAY_DIR_NAME . '/assets/js/trustpay.js?'.TRUSTPAY_VERSION); ?>"></script>
                <iframe id="TrustPayFrame" allow="payment" style="width:0;height:0;border:none"></iframe>
            <?php // } ?>
            
            <?php if ( ! $this->getIframe() ) { ?>
                <script>
                    var isRedirect = true;
                </script>
            <?php } ?>
                
            <?php
        } else {
            ?>
            <div style="color:red"><?php echo __('Currency not supported', 'woocommerce');?>: <?php echo get_woocommerce_currency(); ?></div>
            <?php
        }
    }

    public function process_payment( $order_id ) {
        $order = new WC_Order( $order_id );

        if($paymentMethod = $this->getPaymentMethod()) {

            if(empty($_GET['get_trustpay_type_url'])) {
                global $woocommerce;
                $woocommerce->cart->empty_cart();

                if($order->get_status() != 'pending') {
                    $order->update_status('pending');
                }
            }

            $payment = $this->initPayment($order, $paymentMethod);

            return array(
                'result' => 'success',
                'redirect' => $payment->getUrl(PaymentType::PURCHASE)
            );
        } else {
            $order->update_status('failed');
            
            wc_add_notice(  getTrustPayTranslation('choose_payment_method', $this->getLocale()), 'error' );
            
            return [
                'result'   => 'failure',
                'messages' => getTrustPayTranslation('choose_payment_method', $this->getLocale()),
            ];
        }
    }

    public function callback_wire() {
        $this->checkResponse('\Trustpay\ResponseWire', 'wire');
    }

    public function callback_card() {
        $this->checkResponse('\Trustpay\ResponseCard', 'card');
    }
    
    public function callback_eps() {
        $this->checkResponse('\Trustpay\ResponseEPS', 'eps');
    }
    
    public function callback_giropay() {
        $this->checkResponse('\Trustpay\ResponseGiropay', 'giropay');
    }
    
    public function callback_ideal() {
        $this->checkResponse('\Trustpay\ResponseIdeal', 'ideal');
    }
    
    public function callback_blik() {
        $this->checkResponse('\Trustpay\ResponseBlik', 'blik');
    }
    
    public function callback_openbanking() {
        $this->checkResponse('\Trustpay\ResponseOpenBanking', 'openbanking');
    }
    
    public function callback_tpay() {
        $this->checkResponse('\Trustpay\ResponseTpay', 'tpay');
    }
    
    public function callback_wechatpay() {
        $this->checkResponse('\Trustpay\ResponseWechatpay', 'wechatpay');
    }
    
    public function callback_mybank() {
        $this->checkResponse('\Trustpay\ResponseMyBank', 'mybank');
    }
    
    public function callback_bancontact() {
        $this->checkResponse('\Trustpay\ResponseBancontact', 'bancontact');
    }
    
    public function callback_satispay() {
        $this->checkResponse('\Trustpay\ResponseSatispay', 'satispay');
    }
    
    public function callback_sofort() {
        $this->checkResponse('\Trustpay\ResponseSofort', 'sofort');
    }
    
    public function callback_aircashpay() {
        $this->checkResponse('\Trustpay\ResponseAircashPay', 'aircashpay');
    }
    
    public function callback_paypal() {
        $this->checkResponse('\Trustpay\ResponsePaypal', 'paypal');
    }
    
    public function callback_paytrail() {
        $this->checkResponse('\Trustpay\ResponsePaytrail', 'paytrail');
    }
    
    public function callback_trustly() {
        $this->checkResponse('\Trustpay\ResponseTrustly', 'trustly');
    }
    
    public function callback_paysafecard() {
        $this->checkResponse('\Trustpay\ResponsePaysafecard', 'paysafecard');
    }
    
    public function callback_cashtocode() {
        $this->checkResponse('\Trustpay\ResponseCashToCode', 'cashtocode');
    }
    
    public function callback_payconiq() {
        $this->checkResponse('\Trustpay\ResponsePayconiq', 'payconiq');
    }
    
    public function callback_multibanco() {
        $this->checkResponse('\Trustpay\ResponseMultibanco', 'multibanco');
    }
    
    public function callback_nasplatkytb() {
        $this->checkResponse('\Trustpay\ResponseNasplatkyTB', 'nasplatkytb');
    }
    
    public function callback_skippay() {
        $this->checkResponse('\Trustpay\ResponseSkipPay', 'skippay');
    }
    
    public function callback_sepact() {
        $this->checkResponse('\Trustpay\ResponseSepaCT', 'sepact');
    }
    
    protected function checkResponse($class, $type) {
        $response = new $class($this->getSecretKey());
        $response->initData($_GET);

        if($response->validateSignature()) {
            $this->changeStatus(
                $response->getReference(),
                $response->getResultCode(),
                $response->getTransactionId(),
                $type
            );
        }

        exit;
    }

    protected function changeStatus($order_id, $resultCode, $transaction_id, $type) {
        
        $order = new WC_Order( $order_id );

        switch ($resultCode) {
            case ResultCodes::SUCCESS:
                $order->payment_complete($transaction_id);

                break;
            case ResultCodes::AUTHORIZED:
                if($type === 'card' /*|| $type === 'eps'*/) $order->payment_complete($transaction_id);
                if($type === 'wire') $order->update_status('on-hold', __('Awaiting transaction', 'woocommerce'));

                break;
            case ResultCodes::PROCESSING:
                $order->update_status('on-hold', __('Awaiting transaction', 'woocommerce'));

                break;
            
            case ResultCodes::REJECTED:
                $order->update_status($this->order_status_rejected, __('Rejected transaction', 'woocommerce'));

                break;
        }
    }

    protected function getPaymentMethod() {
        $method = false;

        if(
                isset($_POST['trustpay_gateway_method']) &&
                in_array($_POST['trustpay_gateway_method'],
                    [
                        Payment::ENDPOINT_WIRE,
                        Payment::ENDPOINT_CARD,
                        Payment::ENDPOINT_EPS,
                        Payment::ENDPOINT_GIROPAY,
                        Payment::ENDPOINT_IDEAL,
                        Payment::ENDPOINT_BLIK,
                        Payment::ENDPOINT_OPENBANKING,
                        Payment::ENDPOINT_TPAY,
                        Payment::ENDPOINT_WECHATPAY,
                        Payment::ENDPOINT_MYBANK,
                        Payment::ENDPOINT_BANCONTACT,
                        Payment::ENDPOINT_SATISPAY,
                        Payment::ENDPOINT_SOFORT,
                        Payment::ENDPOINT_AIRCASHPAY,
                        Payment::ENDPOINT_PAYPAL,
                        Payment::ENDPOINT_PAYTRAIL,
                        Payment::ENDPOINT_TRUSTLY,
                        Payment::ENDPOINT_PAYSAFECARD,
                        Payment::ENDPOINT_CASHTOCODE,
                        Payment::ENDPOINT_PAYCONIQ,
                        Payment::ENDPOINT_MULTIBANCO,
                        Payment::ENDPOINT_NASPLATKYTB,
                        Payment::ENDPOINT_SKIPPAY,
                        Payment::ENDPOINT_SEPACT,
                    ]
                )
        ) {
            $method = $_POST['trustpay_gateway_method'];
        }
        
        // blocks
        $data = json_decode(file_get_contents('php://input'), true);
        if(isset ($data['additional_fields']['namespace/trustpay_gateway_method'])) {
            $method = $data['additional_fields']['namespace/trustpay_gateway_method'];
        }

        return $method;
    }

    protected function initPayment($order, $paymentMethod) {
        $trustPayOrder = new Order();
        $trustPayOrder->setId($order->get_id());
        $trustPayOrder->setCurrency($order->get_currency());
        $trustPayOrder->setTotal($order->get_total());
        
        if($paymentMethod == Payment::ENDPOINT_WIRE) {
            $payment = new PaymentWire($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_EPS) {
            $payment = new PaymentEPS($this->getAccountId(), $this->getSecretKey());
            
        } elseif($paymentMethod == Payment::ENDPOINT_GIROPAY) {
            $payment = new PaymentGiropay($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_IDEAL) {
            $payment = new PaymentIdeal($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_OPENBANKING) {
            $payment = new PaymentOpenBanking($this->getAccountId(), $this->getSecretKey());
            $payment->setWCOrder($order);
        } elseif($paymentMethod == Payment::ENDPOINT_BLIK) {
            $payment = new PaymentBlik($this->getAccountId(), $this->getSecretKey());
            
            $trustPayOrder->setCardHolder($order->get_formatted_billing_full_name());
            $trustPayOrder->setEmail($order->get_billing_email());
            
        } elseif($paymentMethod == Payment::ENDPOINT_TPAY) {
            $payment = new PaymentTpay($this->getAccountId(), $this->getSecretKey());
            
            $trustPayOrder->setCardHolder($order->get_formatted_billing_full_name());
            $trustPayOrder->setEmail($order->get_billing_email());
            
        } elseif($paymentMethod == Payment::ENDPOINT_WECHATPAY) {
            $payment = new PaymentWechatpay($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_MYBANK) {
            $payment = new PaymentMyBank($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_BANCONTACT) {
            $payment = new PaymentBancontact($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_SATISPAY) {
            $payment = new PaymentSatispay($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_SOFORT) {
            $payment = new PaymentSofort($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_AIRCASHPAY) {
            $payment = new PaymentAircashPay($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_PAYPAL) {
            $payment = new PaymentPaypal($this->getAccountId(), $this->getSecretKey());
            $payment->setWCOrder($order);
        } elseif($paymentMethod == Payment::ENDPOINT_PAYTRAIL) {
            $payment = new PaymentPaytrail($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_TRUSTLY) {
            $payment = new PaymentTrustly($this->getAccountId(), $this->getSecretKey());
            $payment->setWCOrder($order);
        } elseif($paymentMethod == Payment::ENDPOINT_CASHTOCODE) {
            $payment = new PaymentCashToCode($this->getAccountId(), $this->getSecretKey());
            $payment->setWCOrder($order);
        } elseif($paymentMethod == Payment::ENDPOINT_PAYSAFECARD) {
            $payment = new PaymentPaysafecard($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_PAYCONIQ) {
            $payment = new PaymentPayconiq($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_MULTIBANCO) {
            $payment = new PaymentMultibanco($this->getAccountId(), $this->getSecretKey());
        } elseif($paymentMethod == Payment::ENDPOINT_NASPLATKYTB) {
            $payment = new PaymentNasplatkyTB($this->getAccountId(), $this->getSecretKey());
            $payment->setWCOrder($order);
        } elseif($paymentMethod == Payment::ENDPOINT_SKIPPAY) {
            $payment = new PaymentSkipPay($this->getAccountId(), $this->getSecretKey());
            $payment->setWCOrder($order);
        } elseif($paymentMethod == Payment::ENDPOINT_SEPACT) {
            $payment = new PaymentSepaCT($this->getAccountId(), $this->getSecretKey());
        } else {
            $payment = new PaymentCard($this->getAccountId(), $this->getSecretKey());
        }
        
        $trustPayOrder->setBillingCity($order->get_billing_city());
        $trustPayOrder->setBillingCountry($order->get_billing_country());
        $trustPayOrder->setBillingPostcode($order->get_billing_postcode());
        $trustPayOrder->setBillingStreet($order->get_billing_address_1());
        $trustPayOrder->setCardHolder($order->get_formatted_billing_full_name());
        $trustPayOrder->setEmail($order->get_billing_email());
        
        if($this->getIframe() 
                && $paymentMethod != Payment::ENDPOINT_CASHTOCODE
                && $paymentMethod != Payment::ENDPOINT_PAYPAL
                && $paymentMethod != Payment::ENDPOINT_EPS 
                && $paymentMethod != Payment::ENDPOINT_GIROPAY 
                && $paymentMethod != Payment::ENDPOINT_BANCONTACT
                && $paymentMethod != Payment::ENDPOINT_SOFORT
                && $paymentMethod != Payment::ENDPOINT_PAYSAFECARD
                && $paymentMethod != Payment::ENDPOINT_NASPLATKYTB
                && $paymentMethod != Payment::ENDPOINT_SKIPPAY
        ) {
            $cancelUrl = wc_get_checkout_url();
            $redirect = "false";
        } else {
            $cancelUrl = $order->get_checkout_payment_url();
            $redirect = "true";
        }
        error_log("----IS1:".$redirect);
        
        
        $payment->setOrder($trustPayOrder)
            ->setIsRedirect($redirect)
            ->setSandbox($this->getSandbox())
            ->setNotificationUrl(get_site_url() . '?wc-api=wc_gateway_trustpay_' . $paymentMethod)
            ->setReturnUrl($this->get_return_url( $order ))
            ->setCancelUrl($cancelUrl)
            ->setErrorUrl($cancelUrl)
            ->setLocalization($this->getLocale())
            ->setPaymentMethod($paymentMethod);
        
        return $payment;
    }

    private function getCurrency() {
        return $this->currency;
    }

    private function getAccountId() {
        return $this->getSandbox() ? $this->test_account_id : $this->live_account_id;
    }

    private function getSecretKey() {
        return $this->getSandbox() ? $this->test_secret_key : $this->live_secret_key;
    }

    private function getSandbox() {
        return $this->sandbox == 'yes' ? true : false;
    }

    private function getLocale() {
        return $this->locale;
    }

    private function getShowLogo() {
        return $this->show_logo == 'yes' ? true : false;
    }

    private function getIframe() {
        return $this->iframe == 'yes' ? true : false;
    }
}
