<?php
namespace Trustpay;

class Payment {
    protected $account_id;
    protected $cancelUrl;
    protected $errorUrl;
    protected $localization;
    protected $notificationUrl;
    /* @var Order */
    protected $order;
    protected $paymentMethod;
    protected $returnUrl;
    protected $sandbox;
    protected $secret_key;
    protected $isRedirect;

    protected $Signature;

    const ENDPOINT_CARD = 'card';
    const ENDPOINT_WIRE = 'wire';
    
    const ENDPOINT_EPS = 'eps';
    const ENDPOINT_GIROPAY = 'giropay';
    const ENDPOINT_IDEAL = 'ideal';
    const ENDPOINT_BLIK = 'blik';
    const ENDPOINT_OPENBANKING = 'openbanking';
    const ENDPOINT_TPAY = 'tpay';
    const ENDPOINT_WECHATPAY = 'wechatpay';
    const ENDPOINT_MYBANK = 'mybank';
    const ENDPOINT_BANCONTACT = 'bancontact';
    const ENDPOINT_SATISPAY = 'satispay';
    const ENDPOINT_SOFORT = 'sofort';
    const ENDPOINT_AIRCASHPAY = 'aircashpay';
    const ENDPOINT_PAYPAL = 'paypal';
    const ENDPOINT_PAYTRAIL = 'paytrail';
    const ENDPOINT_TRUSTLY = 'trustly';
    const ENDPOINT_PAYSAFECARD = 'paysafecard';
    const ENDPOINT_CASHTOCODE = 'cashtocode';
    const ENDPOINT_PAYCONIQ = 'payconiq';
    const ENDPOINT_MULTIBANCO = 'multibanco';
    const ENDPOINT_NASPLATKYTB = 'nasplatkytb';
    const ENDPOINT_SKIPPAY = 'skippay';
    const ENDPOINT_SEPACT = 'sepact';
    
    const URL_TOKEN = 'https://aapi.finby.eu/api/oauth2/token';
    const URL_PAYMENT = 'https://aapi.finby.eu/api/Payments/Payment';
    
    public function __construct($account_id, $secret_key) {
        $this->account_id = $account_id;
        $this->secret_key = $secret_key;
    }

    public function setCancelUrl($url) {
        $this->cancelUrl = $url;
        return $this;
    }

    public function setErrorUrl($url) {
        $this->errorUrl = $url;
        return $this;
    }

    public function setNotificationUrl($url) {
        $this->notificationUrl = $url;
        return $this;
    }

    public function setOrder(Order $order) {
        $this->order = $order;
        return $this;
    }

    public function setPaymentMethod($paymentMethod) {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }

    public function setReturnUrl($url) {
        $this->returnUrl = $url;
        return $this;
    }

    public function setSandbox($sandbox) {
        $this->sandbox = $sandbox;
        return $this;
    }

    public function setLocalization($localization) {
        $this->localization = $localization;
        return $this;
    }

    public function setIsRedirect($redirect) {
        $this->isRedirect = $redirect;
        return $this;
    }

    protected function getSignature() {
        if(!$this->Signature) {
            $this->Signature = new Signature($this->secret_key);
        }

        return $this->Signature;
    }

    protected function getIsRedirect() {
        return $this->isRedirect;
    }
}