<?php

/**
 * Plugin Name: Woocommerce finby gateway
 * Plugin URI:
 * Description: This plugin add the payment gateway which allow you to charge the Credit Card and make Instant bank transfer. <a href="https://www.finby.com/">www.finby.com</a>
 * Version: 2.16.4b
 */

define('TRUSTPAY_DIR_NAME', 'woocommerce-trustpay-gateway');
define('TRUSTPAY_PATH', ABSPATH . '/wp-content/plugins/' . TRUSTPAY_DIR_NAME);
define('TRUSTPAY_VERSION', 'woocommerce-2.16.4b');

add_action( 'plugins_loaded', 'init_trustpay_gateway_class', 11 );
add_filter( 'woocommerce_payment_gateways', 'add_trustpay_gateway_class' );
add_filter( 'woocommerce_order_button_html', 'tp_custom_button_html' );

function init_trustpay_gateway_class() {
    require_once TRUSTPAY_PATH . '/src/class-wc-trustpay-gateway.php';
    require_once TRUSTPAY_PATH . '/src/locale.php';
}

function add_trustpay_gateway_class( $methods ) {
    $methods[] = 'WC_Trustpay_Gateway';
    return $methods;
}

function loadTrustPayLibrary() {
    require_once TRUSTPAY_PATH . '/src/lib/Payment.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentWire.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentCard.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentEPS.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentGiropay.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentIdeal.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentBlik.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentOpenBanking.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentTpay.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentWechatpay.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentMyBank.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentBancontact.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentSatispay.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentSofort.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentAircashPay.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentPaypal.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentPaytrail.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentTrustly.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentPaysafecard.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentCashToCode.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentPayconiq.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentMultibanco.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentNasplatkyTB.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentSkipPay.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentSepaCT.php';
    require_once TRUSTPAY_PATH . '/src/lib/Order.php';
    require_once TRUSTPAY_PATH . '/src/lib/PaymentType.php';
    require_once TRUSTPAY_PATH . '/src/lib/Signature.php';
    require_once TRUSTPAY_PATH . '/src/lib/Response.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseWire.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseCard.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseEPS.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseGiropay.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseIdeal.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseBlik.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseOpenBanking.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseTpay.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseWechatpay.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseMyBank.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseBancontact.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseSatispay.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseSofort.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseAircashPay.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponsePaypal.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponsePaytrail.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseTrustly.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponsePaysafecard.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseCashToCode.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseMultibanco.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseNasplatkyTB.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseSkipPay.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResponseSepaCT.php';
    require_once TRUSTPAY_PATH . '/src/lib/ResultCodes.php';
}

function tp_custom_button_html( $button_html ) {
    $button_html = str_replace('class="', 'class="show-popup ', $button_html);
    return $button_html;
}



// blocks
add_action('init', 'trustpay_gateway_register_blocks_support');
function trustpay_gateway_register_blocks_support() {
    if (function_exists('register_payment_method_type')) {
        register_payment_method_type('trustpay_gateway', [
            'scripts' => ['trustpay-gateway-blocks'],
            'supports' => ['products'],
        ]);
    }
}




add_action( 'before_woocommerce_init', function () {
    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
    }
} );

// Register integration with blocks
add_action( 'woocommerce_blocks_loaded', function() {
    require_once plugin_dir_path( __FILE__ ) . 'src/class-wc-trustpay-gateway-blocks.php';
    add_action(
        'woocommerce_blocks_payment_method_type_registration',
        function( Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry ) {
            $payment_method_registry->register( new \TrustPay\Blocks\TrustPayGateway );
        }
    );
} );
